#version 330

#if _DIFFUSE_MAP
uniform sampler2D diffuseMap;
#endif
#if _ALPHA_MAP
uniform sampler2D alphaMap;
#endif
#if DIFFUSE_ARRAY
uniform sampler2DArray texArray;
#endif
#if ALPHA_ARRAY
uniform sampler2DArray texArray;
#endif

in vec4 depthUv;

out vec4 depth;

void main()
{
#if _DIFFUSE_MAP
	vec2 dx = dFdx(depthUv.yz);
	vec2 dy = dFdy(depthUv.yz);
	if(textureGrad(diffuseMap, depthUv.yz, dx, dy).a < 0.5) discard;
#endif
#if _ALPHA_MAP
	vec2 dx = dFdx(depthUv.yz);
	vec2 dy = dFdy(depthUv.yz);
	if(textureGrad(alphaMap, depthUv.yz, dx, dy).r < 0.5) discard;
#endif
#if DIFFUSE_ARRAY
	vec2 dx = dFdx(depthUv.yz);
	vec2 dy = dFdy(depthUv.yz);
	if(textureGrad(texArray, depthUv.yzw, dx, dy).a < 0.5) discard;
#endif
#if ALPHA_ARRAY
	vec2 dx = dFdx(depthUv.yz);
	vec2 dy = dFdy(depthUv.yz);
	if(textureGrad(texArray, depthUv.yzw, dx, dy).r < 0.5) discard;
#endif
	depth = vec4(depthUv.x);
}
